<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Oasia Hotel Downtown - VoiceBot Reservation & Ordering</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Inter', sans-serif;
      background: #f9fafb;
      color: #333;
    }
    header {
      background: #fff;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
      padding: 15px 30px;
      display: flex;
      align-items: center;
    }
    header img {
      height: 70px;
      margin-right: 15px;
      animation: fadeInLeft 1s;
    }
    header h1 {
      font-size: 1.5rem;
      margin: 0;
      color: #1f2937;
      animation: fadeInRight 1s;
    }
    .intro-section {
      text-align: center;
      margin: 40px 0;
      animation: fadeInUp 1s;
    }
    .intro-section h2 {
      font-weight: bold;
      margin-bottom: 15px;
    }
    .intro-section p {
      font-size: 1.1rem;
      color: #4b5563;
    }
    .menu-section h3 {
      margin-bottom: 15px;
      color: #111827;
    }
    .menu-item {
      display: flex;
      justify-content: space-between;
      padding: 8px 0;
      border-bottom: 1px solid #e5e7eb;
    }
    .menu-item:last-child {
      border-bottom: none;
    }
    .btn-custom {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      padding: 12px 20px;
      font-size: 1rem;
      font-weight: 600;
      border-radius: 8px;
      transition: transform 0.2s, background 0.3s;
    }
    .btn-custom:hover {
      transform: translateY(-2px);
    }
    .btn-reservations {
      background: #2563eb;
      color: #fff;
    }
    .btn-reservations:hover {
      background: #1e40af;
    }
    .btn-orders {
      background: #10b981;
      color: #fff;
    }
    .btn-orders:hover {
      background: #059669;
    }
    @keyframes fadeInUp {
      from { opacity: 0; transform: translateY(30px); }
      to { opacity: 1; transform: translateY(0); }
    }
    @keyframes fadeInLeft {
      from { opacity: 0; transform: translateX(-30px); }
      to { opacity: 1; transform: translateX(0); }
    }
    @keyframes fadeInRight {
      from { opacity: 0; transform: translateX(30px); }
      to { opacity: 1; transform: translateX(0); }
    }
  </style>
</head>
<body>
  <header>
    <img src="Logo-removebg.png" alt="VedikIn Solutions Logo" />
    <h1>Oasia Hotel Downtown - VoiceBot </h1>
  </header>

  <main class="container my-5 p-4 bg-white shadow rounded">
    <div class="intro-section">
      <h2>What Can This VoiceBot Do?</h2>
      <p>Our AI-powered VoiceBot allows guests to easily make table reservations, place food orders, and get instant assistance—all through natural voice interaction. It streamlines restaurant operations and enhances guest experiences at Oasia Hotel Downtown, Singapore.</p>
    </div>

    <div class="text-center mb-4">
      <h2 class="fw-bold">Restaurant Menu</h2>
      <p class="text-muted">Discover our carefully crafted menu featuring fresh, flavorful, and satisfying options for every taste.</p>
    </div>

    <div class="row">
  <div class="col-md-6">
    <div class="menu-section">
      <h3>🥪 Sandwiches</h3>
      <div class="menu-item"><span>Spicy Chicken Sandwich</span><span>$8.99</span></div>
      <div class="menu-item"><span>Turkey Club Sandwich</span><span>$9.49</span></div>
      <div class="menu-item"><span>Grilled Veggie Sandwich</span><span>$7.99</span></div>
    </div>

    <div class="menu-section">
      <h3>🥗 Salads</h3>
      <div class="menu-item"><span>Caesar Salad</span><span>$7.49</span></div>
      <div class="menu-item"><span>Greek Salad</span><span>$7.99</span></div>
      <div class="menu-item"><span>Quinoa & Kale Salad</span><span>$8.49</span></div>
    </div>

    <div class="menu-section">
      <h3>🍕 Pizzas</h3>
      <div class="menu-item"><span>Pepperoni Pizza</span><span>$12</span></div>
      <div class="menu-item"><span>Jain Margherita Pizza</span><span>$11</span></div>
      <div class="menu-item"><span>Hawaiian Pizza</span><span>$13</span></div>
      <div class="menu-item"><span>BBQ Chicken Pizza</span><span>$14</span></div>
      <div class="menu-item"><span>Meat Lovers Pizza</span><span>$15</span></div>
      <div class="menu-item"><span>Veggie Supreme Pizza</span><span>$13</span></div>
      <div class="menu-item"><span>Four Cheese Pizza</span><span>$14</span></div>
      <div class="menu-item"><span>Mushroom & Spinach Pizza</span><span>$13</span></div>
      <div class="menu-item"><span>Chicken Alfredo Pizza</span><span>$15</span></div>
      <div class="menu-item"><span>Buffalo Chicken Pizza</span><span>$15</span></div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="menu-section">
      <h3>☕ Beverages</h3>
      <div class="menu-item"><span>Americano Coffee</span><span>$3.49</span></div>
      <div class="menu-item"><span>Cappuccino</span><span>$3.99</span></div>
      <div class="menu-item"><span>Freshly-squeezed Orange Juice</span><span>$4.49</span></div>
    </div>

    <div class="menu-section">
      <h3>🍰 Desserts</h3>
      <div class="menu-item"><span>Cheesecake Slice</span><span>$5.49</span></div>
      <div class="menu-item"><span>Chocolate Brownie</span><span>$3.99</span></div>
      <div class="menu-item"><span>Apple Pie</span><span>$4.90</span></div>
    </div>

    <div class="menu-section">
      <h3>🍕 More Pizzas</h3>
      <div class="menu-item"><span>Seafood Pizza</span><span>$17</span></div>
      <div class="menu-item"><span>Canadian Classic (Pepperoni, Mushrooms, Bacon)</span><span>$14</span></div>
      <div class="menu-item"><span>Tandoori Chicken Pizza</span><span>$15</span></div>
      <div class="menu-item"><span>Teriyaki Chicken Pizza</span><span>$15</span></div>
      <div class="menu-item"><span>Paneer Tikka Pizza</span><span>$14</span></div>
      <div class="menu-item"><span>Smoked Salmon Pizza</span><span>$18</span></div>
      <div class="menu-item"><span>Poutine Pizza</span><span>$16</span></div>
      <div class="menu-item"><span>Butter Chicken Pizza</span><span>$15</span></div>
      <div class="menu-item"><span>Truffle Mushroom Pizza</span><span>$18</span></div>
      <div class="menu-item"><span>Supreme Pizza (Everything mix)</span><span>$16</span></div>
    </div>
  </div>
</div>


    <div class="text-center mt-5">
      <p class="fw-bold mb-3">Check live data here:</p>
      <a href="https://docs.google.com/spreadsheets/d/1lvodBWgiQRDZqIeHA5cyx2ldQsNpT6Iq7L4WnDlV8PQ/edit?usp=sharing" target="_blank" class="btn btn-custom btn-reservations me-3">📋 View Reservations</a>
      <a href="https://docs.google.com/spreadsheets/d/1moCrRyuZarQu-oaGFaInLAnJXn5aoITg8N5N5xB6hig/edit?usp=sharing" target="_blank" class="btn btn-custom btn-orders">🍽️ View Orders</a>
    </div>
  </main>
  <div class="footer" style="margin-top: 70px; text-align: center;">
    <p>&copy; 2025 Vedikin Solutions. All rights reserved.</p>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <elevenlabs-convai agent-id="agent_2401k6az8sggfystp5mmdqw83pdv"></elevenlabs-convai><script src="https://unpkg.com/@elevenlabs/convai-widget-embed" async type="text/javascript"></script>
</body>
</html>